### 实验名称

MongoDB 聚合函数 MapReduce

### 实验目的

1. 掌握 MapReduce 函数
2. 了解 MapReduce 编程模型
3. 了解 Python 编程

### 实验背景

MapReduce 是个非常灵活和强大的数据聚合工具。它的好处是可以把一个聚合任务分解为多个小的任务，分配到多服务器上并行处理。MongoDB 也提供了 MapReduce，做一些比较复杂的统计和聚合操作做花费的时间很长的时候，可以用 MongoDB 中的 MapReduce 进行实现。

### 实验原理

MongoDB 有两种聚合函数：aggregate 与 mapreduce

mapreduce 函数提供的是 mapreduce（编程模型）的聚合操作，它的工作流程如下图所示：

![03-3-1-原理.png](./pic/03-3-1-原理.png)

MongoDB 中的 MapReduce 主要有以下几阶段：

*   Map：把一个操作 Map 到集合中的每一个文档
    
*   Shuffle：根据 Key 分组对文档，并且为每个不同的 Key 生成一系列（>=1个）的值表（List of values）。
    
*   Reduce：处理值表中的元素，直到值表中只有一个元素。然后将值表返回到 Shuffle 过程，循环处理，直到每个 Key 只对应一个值表，并且此值表中只有一个元素，这就是 MR 的结果。
    
*   Finalize：此步骤不是必须的。在得到 MR 最终结果后，再进行一些数据“修剪”性质的处理。
    

### 实验环境

Ubuntu 18.04

Python 3.8

MongoDB 6.0.8

### 建议课时

1课时

### 实验步骤

一、数据准备

0. 启动 mongod 服务

   （1）在指定目录下创建 mongodb 文件夹、其子文件夹 data、log 以及文件 mongodb.log

   ```sh
   cd /home/ubuntu
   mkdir -p mongodb/data
   mkdir -p mongodb/log
   touch mongodb/log/mongodb.log
   ```

   （2）执行 mongod 命令以启动 mongod 服务

   ```sh
   mongod --dbpath /home/ubuntu/mongodb/data --logpath /home/ubuntu/mongodb/log/mongodb.log --logappend --fork
   ```

1. 安装 pymongo 依赖

   ```sh
   pip3 install pymongo==4.1.1 # 注意，需要使用 pip3 安装到 python3 环境下进行使用
   ```

   ![03-3-2-安装pymongo.png](./pic/03-3-2-安装pymongo.png)

2. 进入到 `/home/ubuntu` 目录下，新建 python 文件，命名为 pydtf.py

   ![03-3-3-创建pydtf.png](./pic/03-3-3-创建pydtf.png)

   ![03-3-4-命名pydtf.png](./pic/03-3-4-命名pydtf.png)

3. 导入数据

   （1）编写 python 程序导入数据至 MongoDB 数据库，数据库为 taobao，集合为 order\_info，**注意**：因为数据是随机生成的，所以每个人的数据不一定是一样的

   ```python
   from pymongo import MongoClient
   from random import randint
   import datetime
   
   client = MongoClient('127.0.0.1', 27017)  # 建立连接
   db = client.taobao  # 连接 taobao 数据库
   order = db.order_info  # 设置 order_info 集合
   # 设置文档列表
   status = ['A', 'B', 'C']
   cust_id = ['A123', 'B123', 'C123']
   price = [500, 200, 250, 300]
   sku = ['mmm', 'nnn']
   # 循环生成随机数据
   for i in range(1, 100):
       items = []
       item_count = randint(2, 6)
       for n in range(item_count):
           items.append({"sku": sku[randint(0, 1)], "qty": randint(1, 10), "price": randint(0, 5)})
           # 生成新记录
       new = {
           "status": status[randint(0, 2)],
           "cust_id": cust_id[randint(0, 2)],
           "price": price[randint(0, 3)],
           "ord_date": datetime.datetime.utcnow(),
           "items": items
       }
       print(new)
       # 插入到数据库
       order.insert_one(new)
   print(order.estimated_document_count())
   ```

   ![03-3-5-编写脚本.png](./pic/03-3-5-编写脚本.png)

   （2）运行 pydtf.py，导入数据

   ![03-3-6-运行pydtf-1.png](./pic/03-3-6-运行pydtf-1.png)

   ![03-3-6-运行pydtf-2.png](./pic/03-3-6-运行pydtf-2.png)

3. 查看数据格式

   ```sh
   mongosh # 启动 mongo shell
   use taobao # 切换到 taobao 数据库
   db.order_info.findOne() # 查询 order_info 集合的第一条记录
   ```
   
   ![03-3-7-find0ne.png](./pic/03-3-7-find0ne.png)

二、MapReduce 实操

示例：查询每个 cust\_id 的所有 price 总和

1. 定义 map 函数

   ```js
   var mapFunction1 = function () {
     emit(this.cust_id, this.price)
   }
   ```

2. 定义 reduce 函数

   ```js
   var reduceFunction1 = function (keyCustId, valuesPrices) {
     return Array.sum(valuesPrices)
   }
   ```

3. 执行 mapreduce，输出结果到当前数据库的 map\_reduce\_example 集合中

   ```js
   db.order_info.mapReduce(mapFunction1, reduceFunction1, { out: 'map_reduce_example' })
   ```

   ![03-3-8-定义并执行mapreduce.png](./pic/03-3-8-定义并执行mapreduce.png)

4. 查询结果

   ```js
   db.map_reduce_example.find({})
   ```

   ![03-3-9-查询mapreduce结果.png](./pic/03-3-9-查询mapreduce结果.png)

三、MapReduce 实操

示例：计算所有 items 的平均库存

1. 定义 map 函数

   ```js
   var mapFunction2 = function () {
     for (var idx = 0; idx < this.items.length; idx++) {
       var key = this.items[idx].sku
       var value = {
         count: 1,
         qty: this.items[idx].qty,
       }
       emit(key, value)
     }
   }
   ```

2. 定义reduce函数

   ```js
   var reduceFunction2 = function (keySKU, countObjVals) {
     reducedVal = { count: 0, qty: 0 }
     for (var idx = 0; idx < countObjVals.length; idx++) {
       reducedVal.count += countObjVals[idx].count
       reducedVal.qty += countObjVals[idx].qty
     }
     return reducedVal
   }
   ```

3. 定义 finalize 函数

   ```js
   var finalizeFunction2 = function (key, reducedVal) {
     reducedVal.avg = reducedVal.qty / reducedVal.count
     return reducedVal
   }
   ```

   ![03-3-10-定义函数.png](./pic/03-3-10-定义函数.png)

4. 执行 mapreduce

   ```js
   db.order_info.mapReduce(mapFunction2, reduceFunction2, {
     out: { merge: 'map_reduce_example_2' },
     finalize: finalizeFunction2,
   })
   ```

   ![03-3-11-执行mapreduce.png](./pic/03-3-11-执行mapreduce.png)

5. 查看执行结果

   ```js
   db.map_reduce_example_2.find({})
   ```

   ![03-3-12-查询.png](./pic/03-3-12-查询.png)

### 实验总结

该实验的主要内容是 MongoDB 的 MapReduce 函数的使用，具体内容是：使用 Python 导入数据至数据库，了解 MapReduce 编程模型，通过编写 Map 和 Reduce 对数据库数据进行处理，使用 MapReduce 要实现两个函数 Map 函数和 Reduce 函数，Map 函数调用 emit(key, value) 遍历 collection 中所有的记录，然后将 key 与 value 传递给 Reduce 函数进行处理。Map 函数必须调用 emit(key, value) 返回键值对。综上所述，使用 mapreduce 比 aggregate 复杂，但是更为灵活。